%Napisati MatLAB program koji eksplicitno zadatu funkciju f tabelira na intervalu ciji je levi
%kraj tacka a sa korakom h=1/n, n=1,2,...,m, koristeci tacno k cvorova
%(vrednosti m,k su iz N zadaje korisnik).
%Za svaku vrednost n, program treba da formira odgovarajuci Lagranzov interpolacioni polinom
%koristeci svih k cvorova. Zatim, program treba da omoguci izracunavanje priblizne vrednosti
%funkcije f u proizvoljnoj tacki x nadvuceno koriscenjem dobijenih polinoma uz predjenje
%dobijenih vrednosti sa tacnom vrednoscu f(x nadvuceno). Graficki prikazati.

function lagranz(fun)
  if nargin==0
    error('Greska: Funkciju LAGRANZ morate pozvati sa (bar) jednim argumentom.');
  end
  tekstz;  % tekstz.m
  F=fun;   % eksplicitno zadata F-ja
  a=input('Unesite pocetak intervala. a=');  % levi kraj, tacka a
  m=MyInputN('Unesite broj koraka. m=');     % korak h=1/n, n=1,2,...,m
  k=MyInputN('Unesite broj cvorova. k=');    % broj cvorova
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% definisanje matrice TABLICE formata [k x 2m] cija svaka kolona 2m-1 sadrzi cvorove xi [x0 ... x(k-1)]
% dok svaka kolona 2m sadrzi vrednosti yi [y0 ... y(k-1)]
%
%  | X1 | Y1 | X1 | Y1 | ... | X(2m-1) | Y(2m) |
%  |----|----|----|----|-----|---------|-------|
%  | x1 | y1 | x1 | y1 | ... |    x1   |   y1  |
%  | .. | .. | .. | .. | ... |   ...   |  ...  |
%  | xk | yk | xk | yk | ... |    xk   |   yk  |
%
  TABLICE=zeros(k, 2*m);
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% popunjavanje matrice TABLICE sa vrednostima xi (vrednosti cvorova) i yi (tacne vrednosti f-je)
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  for i=1:k
    for j=1:m
      h=1/j;
      if i==1
        TABLICE(1,j*2-1)=a;
        TABLICE(1,j*2)=F(a); % subs(sym(F),a);
      else
        TABLICE(i,j*2-1)=TABLICE(i-1,j*2-1)+h;
        TABLICE(i,j*2)=F(TABLICE(i,j*2-1));
      end
    end
  end
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% kreiranje matrice LAGRANZI Lagranzovih inpolinoma sa m vrsta (svaka vrsta sadrzi koeficijente istog) i k kolona
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  LAGRANZI=[];  %=zeros(m, k);
  for i=1:m
    clear tempTABLICA;  % pomocna promenljiva formata [m x 2]. Sdrzi kopije vrednosti iz TABLICE, X(2m-1) i Y(2m).
    tempTABLICA(:,1)=TABLICE(:,i*2-1);
    tempTABLICA(:,2)=TABLICE(:,i*2);
    LAGRANZI(i,:)=interpolacija(tempTABLICA);
  end
  fprintf('\n\n-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n')
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% prikaz Tablica tacnih vrednosti
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  for i=1:m
    clear tempTABLICA;
    tempTABLICA(:,1)=TABLICE(:,i*2-1);
    tempTABLICA(:,2)=TABLICE(:,i*2);
    fprintf('Tablica za korak h=1/%d \n', i)
    maxS=str_max(tempTABLICA(:,1));  % maksimalna duzina (karaktera) broja kolone xi
    max2=str_max(tempTABLICA(:,2));  % maksimalna duzina (karaktera) broja kolone yi
    if maxS<max2
      maxS=max2;
    end
    fmt_s=sprintf('%%%ds|',maxS);    % formiranje FORMAT stringa
    % prikaz xi vrste
    fprintf('|xi|')
    for j=1:k
      fprintf(fmt_s,num2str(tempTABLICA(j,1),5))
    end
    % prikaz yi vrste
    fprintf('\n|yi|')
    for j=1:k
      fprintf(fmt_s,num2str(tempTABLICA(j,2),5))
    end
    fprintf('\n\n')
  end
  fprintf('-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n')
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% prikaz svih m Lagranzovih polinoma
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  Tacnost=MyInputN('Unesite tacnost (broj decimala) za prikaz koeficijenata Lagranzovih polinoma: ');
  fprintf('\nIzgled Lagranzovih polinoma: \n\n')
  for i=1:m
    Prikaz=char(vpa(poly2sym(LAGRANZI(i,:),'x'),Tacnost));
    fprintf('L%d,%d = %s \n', k-1, i, Prikaz)
  end
  fprintf('\n-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n\n')
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% racunanje priblizne vrednosti
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  tackaX=input('U kojoj tacki zelite da racunate pribliznu vrednost f(x)? ');
  if ((tackaX<a) | (tackaX>(a+m)))
    fprintf('EKSTRAPOLACIJA: Tacka koju ste uneli ne pripada intervalu [%d, %d].\n',a, (a+m))
  end
  tacnaVrednost=F(tackaX);
  AbsVrednosti=[];
  fprintf('\nTacna vrednost funkcije: f(%d) = %d \n\n',tackaX, tacnaVrednost)
  for i=1:m
    clear M;
    M=LAGRANZI(i,:);             % kopija i-te kolone, tj. koeficijenti i-tog Lagranzovog polinoma
    LVrednost=polyval(M,tackaX); % racunanje vrednosti polinoma u tacki tackaX
    AbsVrednosti(1,i)=abs(LVrednost-tacnaVrednost); % racunanje vrednosti polinoma. ujedno i koordinate Y ose grafika
    fprintf('Priblizna vrednost funkcije: L%d,%d(%d) = %d \n', k-1, i, tackaX, LVrednost)
  end
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% crtanje grafika
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  title('Graficni prikaz greske')
  xlabel('za h=1/n, n=1..m')
  ylabel('|Lk-1(x)-f(x)|')
  Xgraf=1:1:m;  % koordinate X ose
  plot(Xgraf, AbsVrednosti,'-r');  % crtanje grafika funkcije i polinoma za x
  hold on
    plot(Xgraf,AbsVrednosti,'o','MarkerFaceColor','b','MarkerSize',5);  % dodavanje cvorova na grafik
  hold off

  grid on;
  axis on;
  axis manual;
  axis([0 (m+1) min(AbsVrednosti) max(AbsVrednosti)]);
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% funkcija obezbedjuje unos prirodnog broja
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
function y=MyInputN(text)
  a=input(text);
  a=fix(a);
  while (a<0)
    a=input(text);
    a=fix(a);
  end
  y=a;
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% funkcija vraca broj cifara "najduzeg" broja u koloni
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
function y=str_max(kolona)
  MAX=0;
  for i=1:size(kolona,1)
    tmp=size(num2str(kolona(i,1)),2);
    if tmp>MAX
      MAX=tmp;
    end
  end
  y=MAX;
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
% funkcija formira Lagranzov interpolacioni polinom za zadatu tablicu
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
function L=interpolacija(polje)
  L=[0];    % polinom
  w=[0 1];  % pomocna promenljiva pri deljenju
  for i=1:length(polje)   % racuna ceo polinom
    x=[0 1];              % pomocne promenljive za mnozenje
    M=[0 0];
    for j=1:length(polje) % racuna proizvod x-xj/xi-xj
      if i~=j
        w=deconv([1 -polje(j,1)],polje(i,1)-polje(j,1));
        x=conv(x,w);
      end
    end
    M=x*polje(i,2); % x-xj/xi-xj * f(xi)
    L=L+M;
  end
%-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-